package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ForwardedIPHeaderName
import scala.jdk.CollectionConverters._
final case class IPSetForwardedIPConfig(
    headerName: ForwardedIPHeaderName,
    fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior,
    position: zio.aws.wafv2.model.ForwardedIPPosition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.IPSetForwardedIPConfig = {
    import IPSetForwardedIPConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.IPSetForwardedIPConfig
      .builder()
      .headerName(ForwardedIPHeaderName.unwrap(headerName): java.lang.String)
      .fallbackBehavior(fallbackBehavior.unwrap)
      .position(position.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly =
    zio.aws.wafv2.model.IPSetForwardedIPConfig.wrap(buildAwsValue())
}
object IPSetForwardedIPConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.IPSetForwardedIPConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.IPSetForwardedIPConfig =
      zio.aws.wafv2.model
        .IPSetForwardedIPConfig(headerName, fallbackBehavior, position)
    def headerName: ForwardedIPHeaderName
    def fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior
    def position: zio.aws.wafv2.model.ForwardedIPPosition
    def getHeaderName: ZIO[Any, Nothing, ForwardedIPHeaderName] =
      ZIO.succeed(headerName)
    def getFallbackBehavior
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FallbackBehavior] =
      ZIO.succeed(fallbackBehavior)
    def getPosition
        : ZIO[Any, Nothing, zio.aws.wafv2.model.ForwardedIPPosition] =
      ZIO.succeed(position)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetForwardedIPConfig
  ) extends zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly {
    override val headerName: ForwardedIPHeaderName =
      zio.aws.wafv2.model.primitives.ForwardedIPHeaderName(impl.headerName())
    override val fallbackBehavior: zio.aws.wafv2.model.FallbackBehavior =
      zio.aws.wafv2.model.FallbackBehavior.wrap(impl.fallbackBehavior())
    override val position: zio.aws.wafv2.model.ForwardedIPPosition =
      zio.aws.wafv2.model.ForwardedIPPosition.wrap(impl.position())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetForwardedIPConfig
  ): zio.aws.wafv2.model.IPSetForwardedIPConfig.ReadOnly = new Wrapper(impl)
}
