package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRuleGroupResponse(
    summary: Option[zio.aws.wafv2.model.RuleGroupSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse = {
    import CreateRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly =
    zio.aws.wafv2.model.CreateRuleGroupResponse.wrap(buildAwsValue())
}
object CreateRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateRuleGroupResponse =
      zio.aws.wafv2.model
        .CreateRuleGroupResponse(summary.map(value => value.asEditable))
    def summary: Option[zio.aws.wafv2.model.RuleGroupSummary.ReadOnly]
    def getSummary
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RuleGroupSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse
  ) extends zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly {
    override val summary
        : Option[zio.aws.wafv2.model.RuleGroupSummary.ReadOnly] = scala
      .Option(impl.summary())
      .map(value => zio.aws.wafv2.model.RuleGroupSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRuleGroupResponse
  ): zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
