package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  EntityDescription,
  CapacityUnit,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class CreateRuleGroupRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    capacity: CapacityUnit,
    description: Option[EntityDescription] = None,
    rules: Option[Iterable[zio.aws.wafv2.model.Rule]] = None,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    tags: Option[Iterable[zio.aws.wafv2.model.Tag]] = None,
    customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest = {
    import CreateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .capacity(CapacityUnit.unwrap(capacity): java.lang.Long)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateRuleGroupRequest.ReadOnly =
    zio.aws.wafv2.model.CreateRuleGroupRequest.wrap(buildAwsValue())
}
object CreateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateRuleGroupRequest =
      zio.aws.wafv2.model.CreateRuleGroupRequest(
        name,
        scope,
        capacity,
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customResponseBodies.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def capacity: CapacityUnit
    def description: Option[EntityDescription]
    def rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getCapacity: ZIO[Any, Nothing, CapacityUnit] = ZIO.succeed(capacity)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest
  ) extends zio.aws.wafv2.model.CreateRuleGroupRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val capacity: CapacityUnit =
      zio.aws.wafv2.model.primitives.CapacityUnit(impl.capacity())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]] = scala
      .Option(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Rule.wrap(item)
        }.toList
      )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Tag.wrap(item)
        }.toList
      )
    override val customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = scala
      .Option(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRuleGroupRequest
  ): zio.aws.wafv2.model.CreateRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
