package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class UpdateWebAclResponse(nextLockToken: Option[LockToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse = {
    import UpdateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse
      .builder()
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly =
    zio.aws.wafv2.model.UpdateWebAclResponse.wrap(buildAwsValue())
}
object UpdateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateWebAclResponse =
      zio.aws.wafv2.model
        .UpdateWebAclResponse(nextLockToken.map(value => value))
    def nextLockToken: Option[LockToken]
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse
  ) extends zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly {
    override val nextLockToken: Option[LockToken] = scala
      .Option(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateWebAclResponse
  ): zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly = new Wrapper(impl)
}
