package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{
  Action,
  SampleWeight,
  Timestamp,
  ResponseStatusCode,
  EntityName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SampledHTTPRequest(
    request: zio.aws.wafv2.model.HTTPRequest,
    weight: SampleWeight,
    timestamp: Option[Timestamp] = None,
    action: Option[Action] = None,
    ruleNameWithinRuleGroup: Option[EntityName] = None,
    requestHeadersInserted: Option[Iterable[zio.aws.wafv2.model.HTTPHeader]] =
      None,
    responseCodeSent: Option[ResponseStatusCode] = None,
    labels: Option[Iterable[zio.aws.wafv2.model.Label]] = None,
    captchaResponse: Option[zio.aws.wafv2.model.CaptchaResponse] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest = {
    import SampledHTTPRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
      .builder()
      .request(request.buildAwsValue())
      .weight(SampleWeight.unwrap(weight): java.lang.Long)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        action.map(value => Action.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        ruleNameWithinRuleGroup.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.ruleNameWithinRuleGroup)
      .optionallyWith(
        requestHeadersInserted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requestHeadersInserted)
      .optionallyWith(
        responseCodeSent.map(value => ResponseStatusCode.unwrap(value): Integer)
      )(_.responseCodeSent)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(captchaResponse.map(value => value.buildAwsValue()))(
        _.captchaResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly =
    zio.aws.wafv2.model.SampledHTTPRequest.wrap(buildAwsValue())
}
object SampledHTTPRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SampledHTTPRequest =
      zio.aws.wafv2.model.SampledHTTPRequest(
        request.asEditable,
        weight,
        timestamp.map(value => value),
        action.map(value => value),
        ruleNameWithinRuleGroup.map(value => value),
        requestHeadersInserted.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        responseCodeSent.map(value => value),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captchaResponse.map(value => value.asEditable)
      )
    def request: zio.aws.wafv2.model.HTTPRequest.ReadOnly
    def weight: SampleWeight
    def timestamp: Option[Timestamp]
    def action: Option[Action]
    def ruleNameWithinRuleGroup: Option[EntityName]
    def requestHeadersInserted
        : Option[List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]]
    def responseCodeSent: Option[ResponseStatusCode]
    def labels: Option[List[zio.aws.wafv2.model.Label.ReadOnly]]
    def captchaResponse: Option[zio.aws.wafv2.model.CaptchaResponse.ReadOnly]
    def getRequest
        : ZIO[Any, Nothing, zio.aws.wafv2.model.HTTPRequest.ReadOnly] =
      ZIO.succeed(request)
    def getWeight: ZIO[Any, Nothing, SampleWeight] = ZIO.succeed(weight)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getAction: ZIO[Any, AwsError, Action] =
      AwsError.unwrapOptionField("action", action)
    def getRuleNameWithinRuleGroup: ZIO[Any, AwsError, EntityName] = AwsError
      .unwrapOptionField("ruleNameWithinRuleGroup", ruleNameWithinRuleGroup)
    def getRequestHeadersInserted
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]] =
      AwsError.unwrapOptionField(
        "requestHeadersInserted",
        requestHeadersInserted
      )
    def getResponseCodeSent: ZIO[Any, AwsError, ResponseStatusCode] =
      AwsError.unwrapOptionField("responseCodeSent", responseCodeSent)
    def getLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("labels", labels)
    def getCaptchaResponse
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaResponse.ReadOnly] =
      AwsError.unwrapOptionField("captchaResponse", captchaResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ) extends zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly {
    override val request: zio.aws.wafv2.model.HTTPRequest.ReadOnly =
      zio.aws.wafv2.model.HTTPRequest.wrap(impl.request())
    override val weight: SampleWeight =
      zio.aws.wafv2.model.primitives.SampleWeight(impl.weight())
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val action: Option[Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.wafv2.model.primitives.Action(value))
    override val ruleNameWithinRuleGroup: Option[EntityName] = scala
      .Option(impl.ruleNameWithinRuleGroup())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val requestHeadersInserted
        : Option[List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]] = scala
      .Option(impl.requestHeadersInserted())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.HTTPHeader.wrap(item)
        }.toList
      )
    override val responseCodeSent: Option[ResponseStatusCode] = scala
      .Option(impl.responseCodeSent())
      .map(value => zio.aws.wafv2.model.primitives.ResponseStatusCode(value))
    override val labels: Option[List[zio.aws.wafv2.model.Label.ReadOnly]] =
      scala
        .Option(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Label.wrap(item)
          }.toList
        )
    override val captchaResponse
        : Option[zio.aws.wafv2.model.CaptchaResponse.ReadOnly] = scala
      .Option(impl.captchaResponse())
      .map(value => zio.aws.wafv2.model.CaptchaResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ): zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly = new Wrapper(impl)
}
