package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class PutManagedRuleSetVersionsResponse(
    nextLockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse = {
    import PutManagedRuleSetVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse
      .builder()
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly =
    zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.wrap(buildAwsValue())
}
object PutManagedRuleSetVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse =
      zio.aws.wafv2.model
        .PutManagedRuleSetVersionsResponse(nextLockToken.map(value => value))
    def nextLockToken: Option[LockToken]
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse
  ) extends zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly {
    override val nextLockToken: Option[LockToken] = scala
      .Option(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsResponse
  ): zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
