package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutLoggingConfigurationResponse(
    loggingConfiguration: Option[zio.aws.wafv2.model.LoggingConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse = {
    import PutLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.PutLoggingConfigurationResponse.ReadOnly =
    zio.aws.wafv2.model.PutLoggingConfigurationResponse.wrap(buildAwsValue())
}
object PutLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PutLoggingConfigurationResponse =
      zio.aws.wafv2.model.PutLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Option[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse
  ) extends zio.aws.wafv2.model.PutLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Option[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly] = scala
      .Option(impl.loggingConfiguration())
      .map(value => zio.aws.wafv2.model.LoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PutLoggingConfigurationResponse
  ): zio.aws.wafv2.model.PutLoggingConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
