package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LoginPathString
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupConfig(
    loginPath: Option[LoginPathString] = None,
    payloadType: Option[zio.aws.wafv2.model.PayloadType] = None,
    usernameField: Option[zio.aws.wafv2.model.UsernameField] = None,
    passwordField: Option[zio.aws.wafv2.model.PasswordField] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig = {
    import ManagedRuleGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
      .builder()
      .optionallyWith(
        loginPath.map(value => LoginPathString.unwrap(value): java.lang.String)
      )(_.loginPath)
      .optionallyWith(payloadType.map(value => value.unwrap))(_.payloadType)
      .optionallyWith(usernameField.map(value => value.buildAwsValue()))(
        _.usernameField
      )
      .optionallyWith(passwordField.map(value => value.buildAwsValue()))(
        _.passwordField
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupConfig.wrap(buildAwsValue())
}
object ManagedRuleGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupConfig =
      zio.aws.wafv2.model.ManagedRuleGroupConfig(
        loginPath.map(value => value),
        payloadType.map(value => value),
        usernameField.map(value => value.asEditable),
        passwordField.map(value => value.asEditable)
      )
    def loginPath: Option[LoginPathString]
    def payloadType: Option[zio.aws.wafv2.model.PayloadType]
    def usernameField: Option[zio.aws.wafv2.model.UsernameField.ReadOnly]
    def passwordField: Option[zio.aws.wafv2.model.PasswordField.ReadOnly]
    def getLoginPath: ZIO[Any, AwsError, LoginPathString] =
      AwsError.unwrapOptionField("loginPath", loginPath)
    def getPayloadType: ZIO[Any, AwsError, zio.aws.wafv2.model.PayloadType] =
      AwsError.unwrapOptionField("payloadType", payloadType)
    def getUsernameField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.UsernameField.ReadOnly] =
      AwsError.unwrapOptionField("usernameField", usernameField)
    def getPasswordField
        : ZIO[Any, AwsError, zio.aws.wafv2.model.PasswordField.ReadOnly] =
      AwsError.unwrapOptionField("passwordField", passwordField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ) extends zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly {
    override val loginPath: Option[LoginPathString] = scala
      .Option(impl.loginPath())
      .map(value => zio.aws.wafv2.model.primitives.LoginPathString(value))
    override val payloadType: Option[zio.aws.wafv2.model.PayloadType] = scala
      .Option(impl.payloadType())
      .map(value => zio.aws.wafv2.model.PayloadType.wrap(value))
    override val usernameField
        : Option[zio.aws.wafv2.model.UsernameField.ReadOnly] = scala
      .Option(impl.usernameField())
      .map(value => zio.aws.wafv2.model.UsernameField.wrap(value))
    override val passwordField
        : Option[zio.aws.wafv2.model.PasswordField.ReadOnly] = scala
      .Option(impl.passwordField())
      .map(value => zio.aws.wafv2.model.PasswordField.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupConfig
  ): zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly = new Wrapper(impl)
}
