package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    nextMarker: Option[NextMarker] = None,
    tagInfoForResource: Option[zio.aws.wafv2.model.TagInfoForResource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(tagInfoForResource.map(value => value.buildAwsValue()))(
        _.tagInfoForResource
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.wafv2.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListTagsForResourceResponse =
      zio.aws.wafv2.model.ListTagsForResourceResponse(
        nextMarker.map(value => value),
        tagInfoForResource.map(value => value.asEditable)
      )
    def nextMarker: Option[NextMarker]
    def tagInfoForResource
        : Option[zio.aws.wafv2.model.TagInfoForResource.ReadOnly]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTagInfoForResource
        : ZIO[Any, AwsError, zio.aws.wafv2.model.TagInfoForResource.ReadOnly] =
      AwsError.unwrapOptionField("tagInfoForResource", tagInfoForResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse
  ) extends zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val tagInfoForResource
        : Option[zio.aws.wafv2.model.TagInfoForResource.ReadOnly] = scala
      .Option(impl.tagInfoForResource())
      .map(value => zio.aws.wafv2.model.TagInfoForResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListTagsForResourceResponse
  ): zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
