package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{PaginationLimit, NextMarker}
import scala.jdk.CollectionConverters._
final case class ListMobileSdkReleasesRequest(
    platform: zio.aws.wafv2.model.Platform,
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest = {
    import ListMobileSdkReleasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest
      .builder()
      .platform(platform.unwrap)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListMobileSdkReleasesRequest.ReadOnly =
    zio.aws.wafv2.model.ListMobileSdkReleasesRequest.wrap(buildAwsValue())
}
object ListMobileSdkReleasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListMobileSdkReleasesRequest =
      zio.aws.wafv2.model.ListMobileSdkReleasesRequest(
        platform,
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def platform: zio.aws.wafv2.model.Platform
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def getPlatform: ZIO[Any, Nothing, zio.aws.wafv2.model.Platform] =
      ZIO.succeed(platform)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest
  ) extends zio.aws.wafv2.model.ListMobileSdkReleasesRequest.ReadOnly {
    override val platform: zio.aws.wafv2.model.Platform =
      zio.aws.wafv2.model.Platform.wrap(impl.platform())
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafv2.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesRequest
  ): zio.aws.wafv2.model.ListMobileSdkReleasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
