package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListAvailableManagedRuleGroupVersionsResponse(
    nextMarker: Option[NextMarker] = None,
    versions: Option[Iterable[zio.aws.wafv2.model.ManagedRuleGroupVersion]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse = {
    import ListAvailableManagedRuleGroupVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly =
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
      .wrap(buildAwsValue())
}
object ListAvailableManagedRuleGroupVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse =
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse(
        nextMarker.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def versions
        : Option[List[zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ) extends zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val versions
        : Option[List[zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly]] =
      scala
        .Option(impl.versions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleGroupVersion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ): zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
