package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.JsonPointerPath
import scala.jdk.CollectionConverters._
final case class JsonMatchPattern(
    all: Option[zio.aws.wafv2.model.All] = None,
    includedPaths: Option[Iterable[JsonPointerPath]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.JsonMatchPattern = {
    import JsonMatchPattern.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.JsonMatchPattern
      .builder()
      .optionallyWith(all.map(value => value.buildAwsValue()))(_.all)
      .optionallyWith(
        includedPaths.map(value =>
          value.map { item =>
            JsonPointerPath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedPaths)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.JsonMatchPattern.ReadOnly =
    zio.aws.wafv2.model.JsonMatchPattern.wrap(buildAwsValue())
}
object JsonMatchPattern {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.JsonMatchPattern
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.JsonMatchPattern =
      zio.aws.wafv2.model.JsonMatchPattern(
        all.map(value => value.asEditable),
        includedPaths.map(value => value)
      )
    def all: Option[zio.aws.wafv2.model.All.ReadOnly]
    def includedPaths: Option[List[JsonPointerPath]]
    def getAll: ZIO[Any, AwsError, zio.aws.wafv2.model.All.ReadOnly] =
      AwsError.unwrapOptionField("all", all)
    def getIncludedPaths: ZIO[Any, AwsError, List[JsonPointerPath]] =
      AwsError.unwrapOptionField("includedPaths", includedPaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.JsonMatchPattern
  ) extends zio.aws.wafv2.model.JsonMatchPattern.ReadOnly {
    override val all: Option[zio.aws.wafv2.model.All.ReadOnly] =
      scala.Option(impl.all()).map(value => zio.aws.wafv2.model.All.wrap(value))
    override val includedPaths: Option[List[JsonPointerPath]] = scala
      .Option(impl.includedPaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.primitives.JsonPointerPath(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.JsonMatchPattern
  ): zio.aws.wafv2.model.JsonMatchPattern.ReadOnly = new Wrapper(impl)
}
