package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{ResourceArn, EntityId, EntityName}
import scala.jdk.CollectionConverters._
final case class GetRuleGroupRequest(
    name: Option[EntityName] = None,
    scope: Option[zio.aws.wafv2.model.Scope] = None,
    id: Option[EntityId] = None,
    arn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest = {
    import GetRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        id.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly =
    zio.aws.wafv2.model.GetRuleGroupRequest.wrap(buildAwsValue())
}
object GetRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetRuleGroupRequest =
      zio.aws.wafv2.model.GetRuleGroupRequest(
        name.map(value => value),
        scope.map(value => value),
        id.map(value => value),
        arn.map(value => value)
      )
    def name: Option[EntityName]
    def scope: Option[zio.aws.wafv2.model.Scope]
    def id: Option[EntityId]
    def arn: Option[ResourceArn]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getScope: ZIO[Any, AwsError, zio.aws.wafv2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ) extends zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly {
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val scope: Option[zio.aws.wafv2.model.Scope] = scala
      .Option(impl.scope())
      .map(value => zio.aws.wafv2.model.Scope.wrap(value))
    override val id: Option[EntityId] = scala
      .Option(impl.id())
      .map(value => zio.aws.wafv2.model.primitives.EntityId(value))
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRuleGroupRequest
  ): zio.aws.wafv2.model.GetRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
