package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMobileSdkReleaseResponse(
    mobileSdkRelease: Option[zio.aws.wafv2.model.MobileSdkRelease] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse = {
    import GetMobileSdkReleaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse
      .builder()
      .optionallyWith(mobileSdkRelease.map(value => value.buildAwsValue()))(
        _.mobileSdkRelease
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly =
    zio.aws.wafv2.model.GetMobileSdkReleaseResponse.wrap(buildAwsValue())
}
object GetMobileSdkReleaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetMobileSdkReleaseResponse =
      zio.aws.wafv2.model.GetMobileSdkReleaseResponse(
        mobileSdkRelease.map(value => value.asEditable)
      )
    def mobileSdkRelease: Option[zio.aws.wafv2.model.MobileSdkRelease.ReadOnly]
    def getMobileSdkRelease
        : ZIO[Any, AwsError, zio.aws.wafv2.model.MobileSdkRelease.ReadOnly] =
      AwsError.unwrapOptionField("mobileSdkRelease", mobileSdkRelease)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse
  ) extends zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly {
    override val mobileSdkRelease
        : Option[zio.aws.wafv2.model.MobileSdkRelease.ReadOnly] = scala
      .Option(impl.mobileSdkRelease())
      .map(value => zio.aws.wafv2.model.MobileSdkRelease.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseResponse
  ): zio.aws.wafv2.model.GetMobileSdkReleaseResponse.ReadOnly = new Wrapper(
    impl
  )
}
