package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class GetLoggingConfigurationRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest = {
    import GetLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetLoggingConfigurationRequest.ReadOnly =
    zio.aws.wafv2.model.GetLoggingConfigurationRequest.wrap(buildAwsValue())
}
object GetLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetLoggingConfigurationRequest =
      zio.aws.wafv2.model.GetLoggingConfigurationRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest
  ) extends zio.aws.wafv2.model.GetLoggingConfigurationRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetLoggingConfigurationRequest
  ): zio.aws.wafv2.model.GetLoggingConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
