package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class GetIpSetResponse(
    ipSet: Option[zio.aws.wafv2.model.IPSet] = None,
    lockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetIpSetResponse = {
    import GetIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetIpSetResponse.ReadOnly =
    zio.aws.wafv2.model.GetIpSetResponse.wrap(buildAwsValue())
}
object GetIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetIpSetResponse =
      zio.aws.wafv2.model.GetIpSetResponse(
        ipSet.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def ipSet: Option[zio.aws.wafv2.model.IPSet.ReadOnly]
    def lockToken: Option[LockToken]
    def getIpSet: ZIO[Any, AwsError, zio.aws.wafv2.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ) extends zio.aws.wafv2.model.GetIpSetResponse.ReadOnly {
    override val ipSet: Option[zio.aws.wafv2.model.IPSet.ReadOnly] = scala
      .Option(impl.ipSet())
      .map(value => zio.aws.wafv2.model.IPSet.wrap(value))
    override val lockToken: Option[LockToken] = scala
      .Option(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ): zio.aws.wafv2.model.GetIpSetResponse.ReadOnly = new Wrapper(impl)
}
