package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{EntityDescription, EntityName}
import scala.jdk.CollectionConverters._
final case class CreateRegexPatternSetRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    description: Option[EntityDescription] = None,
    regularExpressionList: Iterable[zio.aws.wafv2.model.Regex],
    tags: Option[Iterable[zio.aws.wafv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest = {
    import CreateRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .regularExpressionList(regularExpressionList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateRegexPatternSetRequest.ReadOnly =
    zio.aws.wafv2.model.CreateRegexPatternSetRequest.wrap(buildAwsValue())
}
object CreateRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateRegexPatternSetRequest =
      zio.aws.wafv2.model.CreateRegexPatternSetRequest(
        name,
        scope,
        description.map(value => value),
        regularExpressionList.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def description: Option[EntityDescription]
    def regularExpressionList: List[zio.aws.wafv2.model.Regex.ReadOnly]
    def tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRegularExpressionList
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Regex.ReadOnly]] =
      ZIO.succeed(regularExpressionList)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest
  ) extends zio.aws.wafv2.model.CreateRegexPatternSetRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val regularExpressionList
        : List[zio.aws.wafv2.model.Regex.ReadOnly] = impl
      .regularExpressionList()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Regex.wrap(item)
      }
      .toList
    override val tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateRegexPatternSetRequest
  ): zio.aws.wafv2.model.CreateRegexPatternSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
