package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CountAction(
    customRequestHandling: Option[zio.aws.wafv2.model.CustomRequestHandling] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CountAction = {
    import CountAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CountAction
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CountAction.ReadOnly =
    zio.aws.wafv2.model.CountAction.wrap(buildAwsValue())
}
object CountAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.CountAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CountAction = zio.aws.wafv2.model
      .CountAction(customRequestHandling.map(value => value.asEditable))
    def customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.CustomRequestHandling.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CountAction
  ) extends zio.aws.wafv2.model.CountAction.ReadOnly {
    override val customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly] = scala
      .Option(impl.customRequestHandling())
      .map(value => zio.aws.wafv2.model.CustomRequestHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CountAction
  ): zio.aws.wafv2.model.CountAction.ReadOnly = new Wrapper(impl)
}
