package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Condition(
    actionCondition: Option[zio.aws.wafv2.model.ActionCondition] = None,
    labelNameCondition: Option[zio.aws.wafv2.model.LabelNameCondition] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Condition
      .builder()
      .optionallyWith(actionCondition.map(value => value.buildAwsValue()))(
        _.actionCondition
      )
      .optionallyWith(labelNameCondition.map(value => value.buildAwsValue()))(
        _.labelNameCondition
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Condition.ReadOnly =
    zio.aws.wafv2.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Condition] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Condition =
      zio.aws.wafv2.model.Condition(
        actionCondition.map(value => value.asEditable),
        labelNameCondition.map(value => value.asEditable)
      )
    def actionCondition: Option[zio.aws.wafv2.model.ActionCondition.ReadOnly]
    def labelNameCondition
        : Option[zio.aws.wafv2.model.LabelNameCondition.ReadOnly]
    def getActionCondition
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ActionCondition.ReadOnly] =
      AwsError.unwrapOptionField("actionCondition", actionCondition)
    def getLabelNameCondition
        : ZIO[Any, AwsError, zio.aws.wafv2.model.LabelNameCondition.ReadOnly] =
      AwsError.unwrapOptionField("labelNameCondition", labelNameCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Condition
  ) extends zio.aws.wafv2.model.Condition.ReadOnly {
    override val actionCondition
        : Option[zio.aws.wafv2.model.ActionCondition.ReadOnly] = scala
      .Option(impl.actionCondition())
      .map(value => zio.aws.wafv2.model.ActionCondition.wrap(value))
    override val labelNameCondition
        : Option[zio.aws.wafv2.model.LabelNameCondition.ReadOnly] = scala
      .Option(impl.labelNameCondition())
      .map(value => zio.aws.wafv2.model.LabelNameCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Condition
  ): zio.aws.wafv2.model.Condition.ReadOnly = new Wrapper(impl)
}
