package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{TimeWindowDay, ResourceArn}
import scala.jdk.CollectionConverters._
final case class VersionToPublish(
    associatedRuleGroupArn: Option[ResourceArn] = None,
    forecastedLifetime: Option[TimeWindowDay] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.VersionToPublish = {
    import VersionToPublish.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.VersionToPublish
      .builder()
      .optionallyWith(
        associatedRuleGroupArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.associatedRuleGroupArn)
      .optionallyWith(
        forecastedLifetime.map(value => TimeWindowDay.unwrap(value): Integer)
      )(_.forecastedLifetime)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.VersionToPublish.ReadOnly =
    zio.aws.wafv2.model.VersionToPublish.wrap(buildAwsValue())
}
object VersionToPublish {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.VersionToPublish
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.VersionToPublish =
      zio.aws.wafv2.model.VersionToPublish(
        associatedRuleGroupArn.map(value => value),
        forecastedLifetime.map(value => value)
      )
    def associatedRuleGroupArn: Option[ResourceArn]
    def forecastedLifetime: Option[TimeWindowDay]
    def getAssociatedRuleGroupArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("associatedRuleGroupArn", associatedRuleGroupArn)
    def getForecastedLifetime: ZIO[Any, AwsError, TimeWindowDay] =
      AwsError.unwrapOptionField("forecastedLifetime", forecastedLifetime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.VersionToPublish
  ) extends zio.aws.wafv2.model.VersionToPublish.ReadOnly {
    override val associatedRuleGroupArn: Option[ResourceArn] = scala
      .Option(impl.associatedRuleGroupArn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val forecastedLifetime: Option[TimeWindowDay] = scala
      .Option(impl.forecastedLifetime())
      .map(value => zio.aws.wafv2.model.primitives.TimeWindowDay(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.VersionToPublish
  ): zio.aws.wafv2.model.VersionToPublish.ReadOnly = new Wrapper(impl)
}
