package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Statement(
    byteMatchStatement: Option[zio.aws.wafv2.model.ByteMatchStatement] = None,
    sqliMatchStatement: Option[zio.aws.wafv2.model.SqliMatchStatement] = None,
    xssMatchStatement: Option[zio.aws.wafv2.model.XssMatchStatement] = None,
    sizeConstraintStatement: Option[
      zio.aws.wafv2.model.SizeConstraintStatement
    ] = None,
    geoMatchStatement: Option[zio.aws.wafv2.model.GeoMatchStatement] = None,
    ruleGroupReferenceStatement: Option[
      zio.aws.wafv2.model.RuleGroupReferenceStatement
    ] = None,
    ipSetReferenceStatement: Option[
      zio.aws.wafv2.model.IPSetReferenceStatement
    ] = None,
    regexPatternSetReferenceStatement: Option[
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement
    ] = None,
    rateBasedStatement: Option[zio.aws.wafv2.model.RateBasedStatement] = None,
    andStatement: Option[zio.aws.wafv2.model.AndStatement] = None,
    orStatement: Option[zio.aws.wafv2.model.OrStatement] = None,
    notStatement: Option[zio.aws.wafv2.model.NotStatement] = None,
    managedRuleGroupStatement: Option[
      zio.aws.wafv2.model.ManagedRuleGroupStatement
    ] = None,
    labelMatchStatement: Option[zio.aws.wafv2.model.LabelMatchStatement] = None,
    regexMatchStatement: Option[zio.aws.wafv2.model.RegexMatchStatement] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Statement = {
    import Statement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Statement
      .builder()
      .optionallyWith(byteMatchStatement.map(value => value.buildAwsValue()))(
        _.byteMatchStatement
      )
      .optionallyWith(sqliMatchStatement.map(value => value.buildAwsValue()))(
        _.sqliMatchStatement
      )
      .optionallyWith(xssMatchStatement.map(value => value.buildAwsValue()))(
        _.xssMatchStatement
      )
      .optionallyWith(
        sizeConstraintStatement.map(value => value.buildAwsValue())
      )(_.sizeConstraintStatement)
      .optionallyWith(geoMatchStatement.map(value => value.buildAwsValue()))(
        _.geoMatchStatement
      )
      .optionallyWith(
        ruleGroupReferenceStatement.map(value => value.buildAwsValue())
      )(_.ruleGroupReferenceStatement)
      .optionallyWith(
        ipSetReferenceStatement.map(value => value.buildAwsValue())
      )(_.ipSetReferenceStatement)
      .optionallyWith(
        regexPatternSetReferenceStatement.map(value => value.buildAwsValue())
      )(_.regexPatternSetReferenceStatement)
      .optionallyWith(rateBasedStatement.map(value => value.buildAwsValue()))(
        _.rateBasedStatement
      )
      .optionallyWith(andStatement.map(value => value.buildAwsValue()))(
        _.andStatement
      )
      .optionallyWith(orStatement.map(value => value.buildAwsValue()))(
        _.orStatement
      )
      .optionallyWith(notStatement.map(value => value.buildAwsValue()))(
        _.notStatement
      )
      .optionallyWith(
        managedRuleGroupStatement.map(value => value.buildAwsValue())
      )(_.managedRuleGroupStatement)
      .optionallyWith(labelMatchStatement.map(value => value.buildAwsValue()))(
        _.labelMatchStatement
      )
      .optionallyWith(regexMatchStatement.map(value => value.buildAwsValue()))(
        _.regexMatchStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Statement.ReadOnly =
    zio.aws.wafv2.model.Statement.wrap(buildAwsValue())
}
object Statement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Statement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Statement =
      zio.aws.wafv2.model.Statement(
        byteMatchStatement.map(value => value.asEditable),
        sqliMatchStatement.map(value => value.asEditable),
        xssMatchStatement.map(value => value.asEditable),
        sizeConstraintStatement.map(value => value.asEditable),
        geoMatchStatement.map(value => value.asEditable),
        ruleGroupReferenceStatement.map(value => value.asEditable),
        ipSetReferenceStatement.map(value => value.asEditable),
        regexPatternSetReferenceStatement.map(value => value.asEditable),
        rateBasedStatement.map(value => value.asEditable),
        andStatement.map(value => value.asEditable),
        orStatement.map(value => value.asEditable),
        notStatement.map(value => value.asEditable),
        managedRuleGroupStatement.map(value => value.asEditable),
        labelMatchStatement.map(value => value.asEditable),
        regexMatchStatement.map(value => value.asEditable)
      )
    def byteMatchStatement
        : Option[zio.aws.wafv2.model.ByteMatchStatement.ReadOnly]
    def sqliMatchStatement
        : Option[zio.aws.wafv2.model.SqliMatchStatement.ReadOnly]
    def xssMatchStatement
        : Option[zio.aws.wafv2.model.XssMatchStatement.ReadOnly]
    def sizeConstraintStatement
        : Option[zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly]
    def geoMatchStatement
        : Option[zio.aws.wafv2.model.GeoMatchStatement.ReadOnly]
    def ruleGroupReferenceStatement
        : Option[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly]
    def ipSetReferenceStatement
        : Option[zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly]
    def regexPatternSetReferenceStatement
        : Option[zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly]
    def rateBasedStatement
        : Option[zio.aws.wafv2.model.RateBasedStatement.ReadOnly]
    def andStatement: Option[zio.aws.wafv2.model.AndStatement.ReadOnly]
    def orStatement: Option[zio.aws.wafv2.model.OrStatement.ReadOnly]
    def notStatement: Option[zio.aws.wafv2.model.NotStatement.ReadOnly]
    def managedRuleGroupStatement
        : Option[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly]
    def labelMatchStatement
        : Option[zio.aws.wafv2.model.LabelMatchStatement.ReadOnly]
    def regexMatchStatement
        : Option[zio.aws.wafv2.model.RegexMatchStatement.ReadOnly]
    def getByteMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ByteMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchStatement", byteMatchStatement)
    def getSqliMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SqliMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("sqliMatchStatement", sqliMatchStatement)
    def getXssMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.XssMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchStatement", xssMatchStatement)
    def getSizeConstraintStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sizeConstraintStatement",
      sizeConstraintStatement
    )
    def getGeoMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.GeoMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("geoMatchStatement", geoMatchStatement)
    def getRuleGroupReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ruleGroupReferenceStatement",
      ruleGroupReferenceStatement
    )
    def getIpSetReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ipSetReferenceStatement",
      ipSetReferenceStatement
    )
    def getRegexPatternSetReferenceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "regexPatternSetReferenceStatement",
      regexPatternSetReferenceStatement
    )
    def getRateBasedStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RateBasedStatement.ReadOnly] =
      AwsError.unwrapOptionField("rateBasedStatement", rateBasedStatement)
    def getAndStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AndStatement.ReadOnly] =
      AwsError.unwrapOptionField("andStatement", andStatement)
    def getOrStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OrStatement.ReadOnly] =
      AwsError.unwrapOptionField("orStatement", orStatement)
    def getNotStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.NotStatement.ReadOnly] =
      AwsError.unwrapOptionField("notStatement", notStatement)
    def getManagedRuleGroupStatement: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedRuleGroupStatement",
      managedRuleGroupStatement
    )
    def getLabelMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.LabelMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("labelMatchStatement", labelMatchStatement)
    def getRegexMatchStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RegexMatchStatement.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchStatement", regexMatchStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Statement
  ) extends zio.aws.wafv2.model.Statement.ReadOnly {
    override val byteMatchStatement
        : Option[zio.aws.wafv2.model.ByteMatchStatement.ReadOnly] = scala
      .Option(impl.byteMatchStatement())
      .map(value => zio.aws.wafv2.model.ByteMatchStatement.wrap(value))
    override val sqliMatchStatement
        : Option[zio.aws.wafv2.model.SqliMatchStatement.ReadOnly] = scala
      .Option(impl.sqliMatchStatement())
      .map(value => zio.aws.wafv2.model.SqliMatchStatement.wrap(value))
    override val xssMatchStatement
        : Option[zio.aws.wafv2.model.XssMatchStatement.ReadOnly] = scala
      .Option(impl.xssMatchStatement())
      .map(value => zio.aws.wafv2.model.XssMatchStatement.wrap(value))
    override val sizeConstraintStatement
        : Option[zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly] = scala
      .Option(impl.sizeConstraintStatement())
      .map(value => zio.aws.wafv2.model.SizeConstraintStatement.wrap(value))
    override val geoMatchStatement
        : Option[zio.aws.wafv2.model.GeoMatchStatement.ReadOnly] = scala
      .Option(impl.geoMatchStatement())
      .map(value => zio.aws.wafv2.model.GeoMatchStatement.wrap(value))
    override val ruleGroupReferenceStatement
        : Option[zio.aws.wafv2.model.RuleGroupReferenceStatement.ReadOnly] =
      scala
        .Option(impl.ruleGroupReferenceStatement())
        .map(value =>
          zio.aws.wafv2.model.RuleGroupReferenceStatement.wrap(value)
        )
    override val ipSetReferenceStatement
        : Option[zio.aws.wafv2.model.IPSetReferenceStatement.ReadOnly] = scala
      .Option(impl.ipSetReferenceStatement())
      .map(value => zio.aws.wafv2.model.IPSetReferenceStatement.wrap(value))
    override val regexPatternSetReferenceStatement: Option[
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly
    ] = scala
      .Option(impl.regexPatternSetReferenceStatement())
      .map(value =>
        zio.aws.wafv2.model.RegexPatternSetReferenceStatement.wrap(value)
      )
    override val rateBasedStatement
        : Option[zio.aws.wafv2.model.RateBasedStatement.ReadOnly] = scala
      .Option(impl.rateBasedStatement())
      .map(value => zio.aws.wafv2.model.RateBasedStatement.wrap(value))
    override val andStatement
        : Option[zio.aws.wafv2.model.AndStatement.ReadOnly] = scala
      .Option(impl.andStatement())
      .map(value => zio.aws.wafv2.model.AndStatement.wrap(value))
    override val orStatement: Option[zio.aws.wafv2.model.OrStatement.ReadOnly] =
      scala
        .Option(impl.orStatement())
        .map(value => zio.aws.wafv2.model.OrStatement.wrap(value))
    override val notStatement
        : Option[zio.aws.wafv2.model.NotStatement.ReadOnly] = scala
      .Option(impl.notStatement())
      .map(value => zio.aws.wafv2.model.NotStatement.wrap(value))
    override val managedRuleGroupStatement
        : Option[zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly] = scala
      .Option(impl.managedRuleGroupStatement())
      .map(value => zio.aws.wafv2.model.ManagedRuleGroupStatement.wrap(value))
    override val labelMatchStatement
        : Option[zio.aws.wafv2.model.LabelMatchStatement.ReadOnly] = scala
      .Option(impl.labelMatchStatement())
      .map(value => zio.aws.wafv2.model.LabelMatchStatement.wrap(value))
    override val regexMatchStatement
        : Option[zio.aws.wafv2.model.RegexMatchStatement.ReadOnly] = scala
      .Option(impl.regexMatchStatement())
      .map(value => zio.aws.wafv2.model.RegexMatchStatement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Statement
  ): zio.aws.wafv2.model.Statement.ReadOnly = new Wrapper(impl)
}
