package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  VersionKeyString,
  LabelName,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class ManagedRuleSet(
    name: EntityName,
    id: EntityId,
    arn: ResourceArn,
    description: Option[EntityDescription] = None,
    publishedVersions: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion]
    ] = None,
    recommendedVersion: Option[VersionKeyString] = None,
    labelNamespace: Option[LabelName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleSet = {
    import ManagedRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        publishedVersions.map(value =>
          value
            .map({ case (key, value) =>
              (VersionKeyString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.publishedVersions)
      .optionallyWith(
        recommendedVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.recommendedVersion)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleSet.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleSet.wrap(buildAwsValue())
}
object ManagedRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleSet =
      zio.aws.wafv2.model.ManagedRuleSet(
        name,
        id,
        arn,
        description.map(value => value),
        publishedVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        recommendedVersion.map(value => value),
        labelNamespace.map(value => value)
      )
    def name: EntityName
    def id: EntityId
    def arn: ResourceArn
    def description: Option[EntityDescription]
    def publishedVersions: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly]
    ]
    def recommendedVersion: Option[VersionKeyString]
    def labelNamespace: Option[LabelName]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPublishedVersions: ZIO[Any, AwsError, Map[
      VersionKeyString,
      zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("publishedVersions", publishedVersions)
    def getRecommendedVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("recommendedVersion", recommendedVersion)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ) extends zio.aws.wafv2.model.ManagedRuleSet.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val publishedVersions: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly]
    ] = scala
      .Option(impl.publishedVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.VersionKeyString(
              key
            ) -> zio.aws.wafv2.model.ManagedRuleSetVersion.wrap(value)
          })
          .toMap
      )
    override val recommendedVersion: Option[VersionKeyString] = scala
      .Option(impl.recommendedVersion())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val labelNamespace: Option[LabelName] = scala
      .Option(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ): zio.aws.wafv2.model.ManagedRuleSet.ReadOnly = new Wrapper(impl)
}
