package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListWebAcLsResponse(
    nextMarker: Option[NextMarker] = None,
    webACLs: Option[Iterable[zio.aws.wafv2.model.WebACLSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse = {
    import ListWebAcLsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        webACLs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.webACLs)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly =
    zio.aws.wafv2.model.ListWebAcLsResponse.wrap(buildAwsValue())
}
object ListWebAcLsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListWebAcLsResponse =
      zio.aws.wafv2.model.ListWebAcLsResponse(
        nextMarker.map(value => value),
        webACLs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def webACLs: Option[List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getWebACLs
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]] =
      AwsError.unwrapOptionField("webACLs", webACLs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ) extends zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val webACLs
        : Option[List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]] = scala
      .Option(impl.webACLs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.WebACLSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ): zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly = new Wrapper(impl)
}
