package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class ListResourcesForWebAclRequest(
    webACLArn: ResourceArn,
    resourceType: Option[zio.aws.wafv2.model.ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest = {
    import ListResourcesForWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest
      .builder()
      .webACLArn(ResourceArn.unwrap(webACLArn): java.lang.String)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListResourcesForWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.ListResourcesForWebAclRequest.wrap(buildAwsValue())
}
object ListResourcesForWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListResourcesForWebAclRequest =
      zio.aws.wafv2.model.ListResourcesForWebAclRequest(
        webACLArn,
        resourceType.map(value => value)
      )
    def webACLArn: ResourceArn
    def resourceType: Option[zio.aws.wafv2.model.ResourceType]
    def getWebACLArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(webACLArn)
    def getResourceType: ZIO[Any, AwsError, zio.aws.wafv2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest
  ) extends zio.aws.wafv2.model.ListResourcesForWebAclRequest.ReadOnly {
    override val webACLArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.webACLArn())
    override val resourceType: Option[zio.aws.wafv2.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.wafv2.model.ResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListResourcesForWebAclRequest
  ): zio.aws.wafv2.model.ListResourcesForWebAclRequest.ReadOnly = new Wrapper(
    impl
  )
}
