package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  PaginationLimit,
  NextMarker,
  EntityName,
  VendorName
}
import scala.jdk.CollectionConverters._
final case class ListAvailableManagedRuleGroupVersionsRequest(
    vendorName: VendorName,
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest = {
    import ListAvailableManagedRuleGroupVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
      .builder()
      .vendorName(VendorName.unwrap(vendorName): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest.ReadOnly =
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
      .wrap(buildAwsValue())
}
object ListAvailableManagedRuleGroupVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest =
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest(
        vendorName,
        name,
        scope,
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def vendorName: VendorName
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def getVendorName: ZIO[Any, Nothing, VendorName] = ZIO.succeed(vendorName)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
  ) extends zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest.ReadOnly {
    override val vendorName: VendorName =
      zio.aws.wafv2.model.primitives.VendorName(impl.vendorName())
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafv2.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest
  ): zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
