package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JsonBody(
    matchPattern: zio.aws.wafv2.model.JsonMatchPattern,
    matchScope: zio.aws.wafv2.model.JsonMatchScope,
    invalidFallbackBehavior: Option[
      zio.aws.wafv2.model.BodyParsingFallbackBehavior
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.JsonBody = {
    import JsonBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.JsonBody
      .builder()
      .matchPattern(matchPattern.buildAwsValue())
      .matchScope(matchScope.unwrap)
      .optionallyWith(invalidFallbackBehavior.map(value => value.unwrap))(
        _.invalidFallbackBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.JsonBody.ReadOnly =
    zio.aws.wafv2.model.JsonBody.wrap(buildAwsValue())
}
object JsonBody {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.JsonBody] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.JsonBody = zio.aws.wafv2.model.JsonBody(
      matchPattern.asEditable,
      matchScope,
      invalidFallbackBehavior.map(value => value)
    )
    def matchPattern: zio.aws.wafv2.model.JsonMatchPattern.ReadOnly
    def matchScope: zio.aws.wafv2.model.JsonMatchScope
    def invalidFallbackBehavior
        : Option[zio.aws.wafv2.model.BodyParsingFallbackBehavior]
    def getMatchPattern
        : ZIO[Any, Nothing, zio.aws.wafv2.model.JsonMatchPattern.ReadOnly] =
      ZIO.succeed(matchPattern)
    def getMatchScope: ZIO[Any, Nothing, zio.aws.wafv2.model.JsonMatchScope] =
      ZIO.succeed(matchScope)
    def getInvalidFallbackBehavior
        : ZIO[Any, AwsError, zio.aws.wafv2.model.BodyParsingFallbackBehavior] =
      AwsError.unwrapOptionField(
        "invalidFallbackBehavior",
        invalidFallbackBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.JsonBody
  ) extends zio.aws.wafv2.model.JsonBody.ReadOnly {
    override val matchPattern: zio.aws.wafv2.model.JsonMatchPattern.ReadOnly =
      zio.aws.wafv2.model.JsonMatchPattern.wrap(impl.matchPattern())
    override val matchScope: zio.aws.wafv2.model.JsonMatchScope =
      zio.aws.wafv2.model.JsonMatchScope.wrap(impl.matchScope())
    override val invalidFallbackBehavior
        : Option[zio.aws.wafv2.model.BodyParsingFallbackBehavior] = scala
      .Option(impl.invalidFallbackBehavior())
      .map(value => zio.aws.wafv2.model.BodyParsingFallbackBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.JsonBody
  ): zio.aws.wafv2.model.JsonBody.ReadOnly = new Wrapper(impl)
}
