package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  LockToken,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class IPSetSummary(
    name: Option[EntityName] = None,
    id: Option[EntityId] = None,
    description: Option[EntityDescription] = None,
    lockToken: Option[LockToken] = None,
    arn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.IPSetSummary = {
    import IPSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.IPSetSummary
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.IPSetSummary.ReadOnly =
    zio.aws.wafv2.model.IPSetSummary.wrap(buildAwsValue())
}
object IPSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.IPSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.IPSetSummary =
      zio.aws.wafv2.model.IPSetSummary(
        name.map(value => value),
        id.map(value => value),
        description.map(value => value),
        lockToken.map(value => value),
        arn.map(value => value)
      )
    def name: Option[EntityName]
    def id: Option[EntityId]
    def description: Option[EntityDescription]
    def lockToken: Option[LockToken]
    def arn: Option[ResourceArn]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetSummary
  ) extends zio.aws.wafv2.model.IPSetSummary.ReadOnly {
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val id: Option[EntityId] = scala
      .Option(impl.id())
      .map(value => zio.aws.wafv2.model.primitives.EntityId(value))
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val lockToken: Option[LockToken] = scala
      .Option(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.IPSetSummary
  ): zio.aws.wafv2.model.IPSetSummary.ReadOnly = new Wrapper(impl)
}
