package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class GetRegexPatternSetResponse(
    regexPatternSet: Option[zio.aws.wafv2.model.RegexPatternSet] = None,
    lockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse = {
    import GetRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse
      .builder()
      .optionallyWith(regexPatternSet.map(value => value.buildAwsValue()))(
        _.regexPatternSet
      )
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly =
    zio.aws.wafv2.model.GetRegexPatternSetResponse.wrap(buildAwsValue())
}
object GetRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetRegexPatternSetResponse =
      zio.aws.wafv2.model.GetRegexPatternSetResponse(
        regexPatternSet.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def regexPatternSet: Option[zio.aws.wafv2.model.RegexPatternSet.ReadOnly]
    def lockToken: Option[LockToken]
    def getRegexPatternSet
        : ZIO[Any, AwsError, zio.aws.wafv2.model.RegexPatternSet.ReadOnly] =
      AwsError.unwrapOptionField("regexPatternSet", regexPatternSet)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse
  ) extends zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly {
    override val regexPatternSet
        : Option[zio.aws.wafv2.model.RegexPatternSet.ReadOnly] = scala
      .Option(impl.regexPatternSet())
      .map(value => zio.aws.wafv2.model.RegexPatternSet.wrap(value))
    override val lockToken: Option[LockToken] = scala
      .Option(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetResponse
  ): zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly = new Wrapper(impl)
}
