package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.PolicyString
import scala.jdk.CollectionConverters._
final case class GetPermissionPolicyResponse(
    policy: Option[PolicyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse = {
    import GetPermissionPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly =
    zio.aws.wafv2.model.GetPermissionPolicyResponse.wrap(buildAwsValue())
}
object GetPermissionPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetPermissionPolicyResponse =
      zio.aws.wafv2.model
        .GetPermissionPolicyResponse(policy.map(value => value))
    def policy: Option[PolicyString]
    def getPolicy: ZIO[Any, AwsError, PolicyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse
  ) extends zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly {
    override val policy: Option[PolicyString] = scala
      .Option(impl.policy())
      .map(value => zio.aws.wafv2.model.primitives.PolicyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyResponse
  ): zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
