package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  LabelName,
  CapacityUnit,
  ResourceArn,
  VersionKeyString
}
import scala.jdk.CollectionConverters._
final case class DescribeManagedRuleGroupResponse(
    versionName: Option[VersionKeyString] = None,
    snsTopicArn: Option[ResourceArn] = None,
    capacity: Option[CapacityUnit] = None,
    rules: Option[Iterable[zio.aws.wafv2.model.RuleSummary]] = None,
    labelNamespace: Option[LabelName] = None,
    availableLabels: Option[Iterable[zio.aws.wafv2.model.LabelSummary]] = None,
    consumedLabels: Option[Iterable[zio.aws.wafv2.model.LabelSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse = {
    import DescribeManagedRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
      .builder()
      .optionallyWith(
        versionName.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        snsTopicArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        capacity.map(value => CapacityUnit.unwrap(value): java.lang.Long)
      )(_.capacity)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .optionallyWith(
        availableLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableLabels)
      .optionallyWith(
        consumedLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedLabels)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly =
    zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.wrap(buildAwsValue())
}
object DescribeManagedRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DescribeManagedRuleGroupResponse =
      zio.aws.wafv2.model.DescribeManagedRuleGroupResponse(
        versionName.map(value => value),
        snsTopicArn.map(value => value),
        capacity.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labelNamespace.map(value => value),
        availableLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def versionName: Option[VersionKeyString]
    def snsTopicArn: Option[ResourceArn]
    def capacity: Option[CapacityUnit]
    def rules: Option[List[zio.aws.wafv2.model.RuleSummary.ReadOnly]]
    def labelNamespace: Option[LabelName]
    def availableLabels: Option[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def consumedLabels: Option[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]]
    def getVersionName: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getSnsTopicArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getCapacity: ZIO[Any, AwsError, CapacityUnit] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.RuleSummary.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getAvailableLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("availableLabels", availableLabels)
    def getConsumedLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] =
      AwsError.unwrapOptionField("consumedLabels", consumedLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ) extends zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly {
    override val versionName: Option[VersionKeyString] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val snsTopicArn: Option[ResourceArn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val capacity: Option[CapacityUnit] = scala
      .Option(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.CapacityUnit(value))
    override val rules: Option[List[zio.aws.wafv2.model.RuleSummary.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.RuleSummary.wrap(item)
          }.toList
        )
    override val labelNamespace: Option[LabelName] = scala
      .Option(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
    override val availableLabels
        : Option[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] = scala
      .Option(impl.availableLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.LabelSummary.wrap(item)
        }.toList
      )
    override val consumedLabels
        : Option[List[zio.aws.wafv2.model.LabelSummary.ReadOnly]] = scala
      .Option(impl.consumedLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.LabelSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedRuleGroupResponse
  ): zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
