package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{EntityDescription, EntityName}
import scala.jdk.CollectionConverters._
final case class CreateWebAclRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    defaultAction: zio.aws.wafv2.model.DefaultAction,
    description: Option[EntityDescription] = None,
    rules: Option[Iterable[zio.aws.wafv2.model.Rule]] = None,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    tags: Option[Iterable[zio.aws.wafv2.model.Tag]] = None,
    customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = None,
    captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest = {
    import CreateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .defaultAction(defaultAction.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.CreateWebAclRequest.wrap(buildAwsValue())
}
object CreateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateWebAclRequest =
      zio.aws.wafv2.model.CreateWebAclRequest(
        name,
        scope,
        defaultAction.asEditable,
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customResponseBodies.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        captchaConfig.map(value => value.asEditable)
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly
    def description: Option[EntityDescription]
    def rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafv2.model.DefaultAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ) extends zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly =
      zio.aws.wafv2.model.DefaultAction.wrap(impl.defaultAction())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Option[List[zio.aws.wafv2.model.Rule.ReadOnly]] = scala
      .Option(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Rule.wrap(item)
        }.toList
      )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Tag.wrap(item)
        }.toList
      )
    override val customResponseBodies: Option[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = scala
      .Option(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
    override val captchaConfig
        : Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] = scala
      .Option(impl.captchaConfig())
      .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ): zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly = new Wrapper(impl)
}
