package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AllowAction(
    customRequestHandling: Option[zio.aws.wafv2.model.CustomRequestHandling] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AllowAction = {
    import AllowAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AllowAction
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AllowAction.ReadOnly =
    zio.aws.wafv2.model.AllowAction.wrap(buildAwsValue())
}
object AllowAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.AllowAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AllowAction = zio.aws.wafv2.model
      .AllowAction(customRequestHandling.map(value => value.asEditable))
    def customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.CustomRequestHandling.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AllowAction
  ) extends zio.aws.wafv2.model.AllowAction.ReadOnly {
    override val customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly] = scala
      .Option(impl.customRequestHandling())
      .map(value => zio.aws.wafv2.model.CustomRequestHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AllowAction
  ): zio.aws.wafv2.model.AllowAction.ReadOnly = new Wrapper(impl)
}
