package zio.aws.wafv2
import zio.aws.wafv2.model.PutLoggingConfigurationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.wafv2.Wafv2AsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.wafv2.model.{
  UpdateWebAclRequest,
  GetRuleGroupRequest,
  GetLoggingConfigurationRequest,
  AssociateWebAclRequest,
  DeleteWebAclRequest,
  DeleteRuleGroupRequest,
  GetIpSetRequest,
  GetPermissionPolicyRequest,
  UpdateIpSetRequest,
  PutPermissionPolicyRequest,
  GetManagedRuleSetRequest,
  ListTagsForResourceRequest,
  GetRegexPatternSetRequest,
  ListRuleGroupsRequest,
  PutLoggingConfigurationRequest,
  ListLoggingConfigurationsRequest,
  DeleteIpSetRequest,
  GetRateBasedStatementManagedKeysRequest,
  DeletePermissionPolicyRequest,
  CheckCapacityRequest,
  GetWebAclRequest,
  DeleteLoggingConfigurationRequest,
  ListAvailableManagedRuleGroupVersionsRequest,
  ListAvailableManagedRuleGroupsRequest,
  DescribeManagedRuleGroupRequest,
  DisassociateWebAclRequest,
  DeleteRegexPatternSetRequest,
  CreateRegexPatternSetRequest,
  GetSampledRequestsRequest,
  UpdateRuleGroupRequest,
  ListResourcesForWebAclRequest,
  UntagResourceRequest,
  CreateRuleGroupRequest,
  ListManagedRuleSetsRequest,
  DeleteFirewallManagerRuleGroupsRequest,
  PutManagedRuleSetVersionsRequest,
  GetWebAclForResourceRequest,
  UpdateRegexPatternSetRequest,
  TagResourceRequest,
  ListWebAcLsRequest,
  UpdateManagedRuleSetVersionExpiryDateRequest,
  CreateWebAclRequest,
  ListRegexPatternSetsRequest,
  ListIpSetsRequest,
  CreateIpSetRequest
}
object Wafv2Mock extends Mock[Wafv2] {
  object GetRuleGroup
      extends Effect[
        GetRuleGroupRequest,
        AwsError,
        zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly
      ]
  object GetWebACL
      extends Effect[
        GetWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.GetWebAclResponse.ReadOnly
      ]
  object GetIPSet
      extends Effect[
        GetIpSetRequest,
        AwsError,
        zio.aws.wafv2.model.GetIpSetResponse.ReadOnly
      ]
  object CreateRuleGroup
      extends Effect[
        CreateRuleGroupRequest,
        AwsError,
        zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly
      ]
  object ListRuleGroups
      extends Effect[
        ListRuleGroupsRequest,
        AwsError,
        zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly
      ]
  object DeleteRegexPatternSet
      extends Effect[
        DeleteRegexPatternSetRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteRegexPatternSetResponse.ReadOnly
      ]
  object DisassociateWebACL
      extends Effect[
        DisassociateWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.DisassociateWebAclResponse.ReadOnly
      ]
  object ListResourcesForWebACL
      extends Effect[
        ListResourcesForWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly
      ]
  object CreateIPSet
      extends Effect[
        CreateIpSetRequest,
        AwsError,
        zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly
      ]
  object GetWebACLForResource
      extends Effect[
        GetWebAclForResourceRequest,
        AwsError,
        zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly
      ]
  object ListRegexPatternSets
      extends Effect[
        ListRegexPatternSetsRequest,
        AwsError,
        zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly
      ]
  object UpdateIPSet
      extends Effect[
        UpdateIpSetRequest,
        AwsError,
        zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly
      ]
  object UpdateManagedRuleSetVersionExpiryDate
      extends Effect[
        UpdateManagedRuleSetVersionExpiryDateRequest,
        AwsError,
        zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly
      ]
  object GetManagedRuleSet
      extends Effect[
        GetManagedRuleSetRequest,
        AwsError,
        zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly
      ]
  object ListAvailableManagedRuleGroups
      extends Effect[
        ListAvailableManagedRuleGroupsRequest,
        AwsError,
        zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly
      ]
  object CheckCapacity
      extends Effect[
        CheckCapacityRequest,
        AwsError,
        zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly
      ]
  object PutManagedRuleSetVersions
      extends Effect[
        PutManagedRuleSetVersionsRequest,
        AwsError,
        zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly
      ]
  object AssociateWebACL
      extends Effect[
        AssociateWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.AssociateWebAclResponse.ReadOnly
      ]
  object GetRegexPatternSet
      extends Effect[
        GetRegexPatternSetRequest,
        AwsError,
        zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.wafv2.model.UntagResourceResponse.ReadOnly
      ]
  object PutLoggingConfiguration
      extends Effect[PutLoggingConfigurationRequest, AwsError, ReadOnly]
  object DescribeManagedRuleGroup
      extends Effect[
        DescribeManagedRuleGroupRequest,
        AwsError,
        zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly
      ]
  object DeleteWebACL
      extends Effect[
        DeleteWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteWebAclResponse.ReadOnly
      ]
  object ListAvailableManagedRuleGroupVersions
      extends Effect[
        ListAvailableManagedRuleGroupVersionsRequest,
        AwsError,
        zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly
      ]
  object CreateRegexPatternSet
      extends Effect[
        CreateRegexPatternSetRequest,
        AwsError,
        zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly
      ]
  object ListWebACLs
      extends Effect[
        ListWebAcLsRequest,
        AwsError,
        zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly
      ]
  object PutPermissionPolicy
      extends Effect[
        PutPermissionPolicyRequest,
        AwsError,
        zio.aws.wafv2.model.PutPermissionPolicyResponse.ReadOnly
      ]
  object GetLoggingConfiguration
      extends Effect[
        GetLoggingConfigurationRequest,
        AwsError,
        zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteFirewallManagerRuleGroups
      extends Effect[
        DeleteFirewallManagerRuleGroupsRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.wafv2.model.TagResourceResponse.ReadOnly
      ]
  object ListLoggingConfigurations
      extends Effect[
        ListLoggingConfigurationsRequest,
        AwsError,
        zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly
      ]
  object DeleteLoggingConfiguration
      extends Effect[
        DeleteLoggingConfigurationRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.ReadOnly
      ]
  object ListManagedRuleSets
      extends Effect[
        ListManagedRuleSetsRequest,
        AwsError,
        zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly
      ]
  object UpdateRuleGroup
      extends Effect[
        UpdateRuleGroupRequest,
        AwsError,
        zio.aws.wafv2.model.UpdateRuleGroupResponse.ReadOnly
      ]
  object UpdateRegexPatternSet
      extends Effect[
        UpdateRegexPatternSetRequest,
        AwsError,
        zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly
      ]
  object GetRateBasedStatementManagedKeys
      extends Effect[
        GetRateBasedStatementManagedKeysRequest,
        AwsError,
        zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly
      ]
  object CreateWebACL
      extends Effect[
        CreateWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly
      ]
  object GetPermissionPolicy
      extends Effect[
        GetPermissionPolicyRequest,
        AwsError,
        zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly
      ]
  object UpdateWebACL
      extends Effect[
        UpdateWebAclRequest,
        AwsError,
        zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly
      ]
  object DeleteRuleGroup
      extends Effect[
        DeleteRuleGroupRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteRuleGroupResponse.ReadOnly
      ]
  object ListIPSets
      extends Effect[
        ListIpSetsRequest,
        AwsError,
        zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly
      ]
  object GetSampledRequests
      extends Effect[
        GetSampledRequestsRequest,
        AwsError,
        zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly
      ]
  object DeleteIPSet
      extends Effect[
        DeleteIpSetRequest,
        AwsError,
        zio.aws.wafv2.model.DeleteIpSetResponse.ReadOnly
      ]
  object DeletePermissionPolicy
      extends Effect[
        DeletePermissionPolicyRequest,
        AwsError,
        zio.aws.wafv2.model.DeletePermissionPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Wafv2] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Wafv2 {
          val api: Wafv2AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Wafv2 = this
          def getRuleGroup(
              request: GetRuleGroupRequest
          ): IO[AwsError, zio.aws.wafv2.model.GetRuleGroupResponse.ReadOnly] =
            proxy(GetRuleGroup, request)
          def getWebACL(
              request: GetWebAclRequest
          ): IO[AwsError, zio.aws.wafv2.model.GetWebAclResponse.ReadOnly] =
            proxy(GetWebACL, request)
          def getIPSet(
              request: GetIpSetRequest
          ): IO[AwsError, zio.aws.wafv2.model.GetIpSetResponse.ReadOnly] =
            proxy(GetIPSet, request)
          def createRuleGroup(request: CreateRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafv2.model.CreateRuleGroupResponse.ReadOnly
          ] = proxy(CreateRuleGroup, request)
          def listRuleGroups(
              request: ListRuleGroupsRequest
          ): IO[AwsError, zio.aws.wafv2.model.ListRuleGroupsResponse.ReadOnly] =
            proxy(ListRuleGroups, request)
          def deleteRegexPatternSet(request: DeleteRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafv2.model.DeleteRegexPatternSetResponse.ReadOnly
          ] = proxy(DeleteRegexPatternSet, request)
          def disassociateWebACL(request: DisassociateWebAclRequest): IO[
            AwsError,
            zio.aws.wafv2.model.DisassociateWebAclResponse.ReadOnly
          ] = proxy(DisassociateWebACL, request)
          def listResourcesForWebACL(
              request: ListResourcesForWebAclRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.ListResourcesForWebAclResponse.ReadOnly
          ] = proxy(ListResourcesForWebACL, request)
          def createIPSet(
              request: CreateIpSetRequest
          ): IO[AwsError, zio.aws.wafv2.model.CreateIpSetResponse.ReadOnly] =
            proxy(CreateIPSet, request)
          def getWebACLForResource(request: GetWebAclForResourceRequest): IO[
            AwsError,
            zio.aws.wafv2.model.GetWebAclForResourceResponse.ReadOnly
          ] = proxy(GetWebACLForResource, request)
          def listRegexPatternSets(request: ListRegexPatternSetsRequest): IO[
            AwsError,
            zio.aws.wafv2.model.ListRegexPatternSetsResponse.ReadOnly
          ] = proxy(ListRegexPatternSets, request)
          def updateIPSet(
              request: UpdateIpSetRequest
          ): IO[AwsError, zio.aws.wafv2.model.UpdateIpSetResponse.ReadOnly] =
            proxy(UpdateIPSet, request)
          def updateManagedRuleSetVersionExpiryDate(
              request: UpdateManagedRuleSetVersionExpiryDateRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly
          ] = proxy(UpdateManagedRuleSetVersionExpiryDate, request)
          def getManagedRuleSet(request: GetManagedRuleSetRequest): IO[
            AwsError,
            zio.aws.wafv2.model.GetManagedRuleSetResponse.ReadOnly
          ] = proxy(GetManagedRuleSet, request)
          def listAvailableManagedRuleGroups(
              request: ListAvailableManagedRuleGroupsRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.ListAvailableManagedRuleGroupsResponse.ReadOnly
          ] = proxy(ListAvailableManagedRuleGroups, request)
          def checkCapacity(
              request: CheckCapacityRequest
          ): IO[AwsError, zio.aws.wafv2.model.CheckCapacityResponse.ReadOnly] =
            proxy(CheckCapacity, request)
          def putManagedRuleSetVersions(
              request: PutManagedRuleSetVersionsRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.PutManagedRuleSetVersionsResponse.ReadOnly
          ] = proxy(PutManagedRuleSetVersions, request)
          def associateWebACL(request: AssociateWebAclRequest): IO[
            AwsError,
            zio.aws.wafv2.model.AssociateWebAclResponse.ReadOnly
          ] = proxy(AssociateWebACL, request)
          def getRegexPatternSet(request: GetRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafv2.model.GetRegexPatternSetResponse.ReadOnly
          ] = proxy(GetRegexPatternSet, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.wafv2.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def putLoggingConfiguration(
              request: PutLoggingConfigurationRequest
          ): IO[AwsError, ReadOnly] = proxy(PutLoggingConfiguration, request)
          def describeManagedRuleGroup(
              request: DescribeManagedRuleGroupRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.DescribeManagedRuleGroupResponse.ReadOnly
          ] = proxy(DescribeManagedRuleGroup, request)
          def deleteWebACL(
              request: DeleteWebAclRequest
          ): IO[AwsError, zio.aws.wafv2.model.DeleteWebAclResponse.ReadOnly] =
            proxy(DeleteWebACL, request)
          def listAvailableManagedRuleGroupVersions(
              request: ListAvailableManagedRuleGroupVersionsRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly
          ] = proxy(ListAvailableManagedRuleGroupVersions, request)
          def createRegexPatternSet(request: CreateRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafv2.model.CreateRegexPatternSetResponse.ReadOnly
          ] = proxy(CreateRegexPatternSet, request)
          def listWebACLs(
              request: ListWebAcLsRequest
          ): IO[AwsError, zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly] =
            proxy(ListWebACLs, request)
          def putPermissionPolicy(request: PutPermissionPolicyRequest): IO[
            AwsError,
            zio.aws.wafv2.model.PutPermissionPolicyResponse.ReadOnly
          ] = proxy(PutPermissionPolicy, request)
          def getLoggingConfiguration(
              request: GetLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.GetLoggingConfigurationResponse.ReadOnly
          ] = proxy(GetLoggingConfiguration, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.wafv2.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def deleteFirewallManagerRuleGroups(
              request: DeleteFirewallManagerRuleGroupsRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly
          ] = proxy(DeleteFirewallManagerRuleGroups, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.wafv2.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def listLoggingConfigurations(
              request: ListLoggingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly
          ] = proxy(ListLoggingConfigurations, request)
          def deleteLoggingConfiguration(
              request: DeleteLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.DeleteLoggingConfigurationResponse.ReadOnly
          ] = proxy(DeleteLoggingConfiguration, request)
          def listManagedRuleSets(request: ListManagedRuleSetsRequest): IO[
            AwsError,
            zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly
          ] = proxy(ListManagedRuleSets, request)
          def updateRuleGroup(request: UpdateRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafv2.model.UpdateRuleGroupResponse.ReadOnly
          ] = proxy(UpdateRuleGroup, request)
          def updateRegexPatternSet(request: UpdateRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafv2.model.UpdateRegexPatternSetResponse.ReadOnly
          ] = proxy(UpdateRegexPatternSet, request)
          def getRateBasedStatementManagedKeys(
              request: GetRateBasedStatementManagedKeysRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.GetRateBasedStatementManagedKeysResponse.ReadOnly
          ] = proxy(GetRateBasedStatementManagedKeys, request)
          def createWebACL(
              request: CreateWebAclRequest
          ): IO[AwsError, zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly] =
            proxy(CreateWebACL, request)
          def getPermissionPolicy(request: GetPermissionPolicyRequest): IO[
            AwsError,
            zio.aws.wafv2.model.GetPermissionPolicyResponse.ReadOnly
          ] = proxy(GetPermissionPolicy, request)
          def updateWebACL(
              request: UpdateWebAclRequest
          ): IO[AwsError, zio.aws.wafv2.model.UpdateWebAclResponse.ReadOnly] =
            proxy(UpdateWebACL, request)
          def deleteRuleGroup(request: DeleteRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafv2.model.DeleteRuleGroupResponse.ReadOnly
          ] = proxy(DeleteRuleGroup, request)
          def listIPSets(
              request: ListIpSetsRequest
          ): IO[AwsError, zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly] =
            proxy(ListIPSets, request)
          def getSampledRequests(request: GetSampledRequestsRequest): IO[
            AwsError,
            zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly
          ] = proxy(GetSampledRequests, request)
          def deleteIPSet(
              request: DeleteIpSetRequest
          ): IO[AwsError, zio.aws.wafv2.model.DeleteIpSetResponse.ReadOnly] =
            proxy(DeleteIPSet, request)
          def deletePermissionPolicy(
              request: DeletePermissionPolicyRequest
          ): IO[
            AwsError,
            zio.aws.wafv2.model.DeletePermissionPolicyResponse.ReadOnly
          ] = proxy(DeletePermissionPolicy, request)
        }
      }
    }
    .toLayer
}
