package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OverrideAction(
    count: Option[zio.aws.wafv2.model.CountAction] = None,
    none: Option[zio.aws.wafv2.model.NoneAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.OverrideAction = {
    import OverrideAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.OverrideAction
      .builder()
      .optionallyWith(count.map(value => value.buildAwsValue()))(_.count)
      .optionallyWith(none.map(value => value.buildAwsValue()))(_.none)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.OverrideAction.ReadOnly =
    zio.aws.wafv2.model.OverrideAction.wrap(buildAwsValue())
}
object OverrideAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.OverrideAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.OverrideAction =
      zio.aws.wafv2.model.OverrideAction(
        count.map(value => value.asEditable),
        none.map(value => value.asEditable)
      )
    def count: Option[zio.aws.wafv2.model.CountAction.ReadOnly]
    def none: Option[zio.aws.wafv2.model.NoneAction.ReadOnly]
    def getCount: ZIO[Any, AwsError, zio.aws.wafv2.model.CountAction.ReadOnly] =
      AwsError.unwrapOptionField("count", count)
    def getNone: ZIO[Any, AwsError, zio.aws.wafv2.model.NoneAction.ReadOnly] =
      AwsError.unwrapOptionField("none", none)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.OverrideAction
  ) extends zio.aws.wafv2.model.OverrideAction.ReadOnly {
    override val count: Option[zio.aws.wafv2.model.CountAction.ReadOnly] = scala
      .Option(impl.count())
      .map(value => zio.aws.wafv2.model.CountAction.wrap(value))
    override val none: Option[zio.aws.wafv2.model.NoneAction.ReadOnly] = scala
      .Option(impl.none())
      .map(value => zio.aws.wafv2.model.NoneAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.OverrideAction
  ): zio.aws.wafv2.model.OverrideAction.ReadOnly = new Wrapper(impl)
}
