package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{VersionKeyString, EntityName, VendorName}
import scala.jdk.CollectionConverters._
final case class ManagedRuleGroupStatement(
    vendorName: VendorName,
    name: EntityName,
    version: Option[VersionKeyString] = None,
    excludedRules: Option[Iterable[zio.aws.wafv2.model.ExcludedRule]] = None,
    scopeDownStatement: Option[zio.aws.wafv2.model.Statement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement = {
    import ManagedRuleGroupStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
      .builder()
      .vendorName(VendorName.unwrap(vendorName): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => VersionKeyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .optionallyWith(scopeDownStatement.map(value => value.buildAwsValue()))(
        _.scopeDownStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupStatement.wrap(buildAwsValue())
}
object ManagedRuleGroupStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupStatement =
      zio.aws.wafv2.model.ManagedRuleGroupStatement(
        vendorName,
        name,
        version.map(value => value),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scopeDownStatement.map(value => value.asEditable)
      )
    def vendorName: VendorName
    def name: EntityName
    def version: Option[VersionKeyString]
    def excludedRules: Option[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]]
    def scopeDownStatement: Option[zio.aws.wafv2.model.Statement.ReadOnly]
    def getVendorName: ZIO[Any, Nothing, VendorName] = ZIO.succeed(vendorName)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("version", version)
    def getExcludedRules
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludedRules", excludedRules)
    def getScopeDownStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.Statement.ReadOnly] =
      AwsError.unwrapOptionField("scopeDownStatement", scopeDownStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ) extends zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly {
    override val vendorName: VendorName =
      zio.aws.wafv2.model.primitives.VendorName(impl.vendorName())
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val version: Option[VersionKeyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val excludedRules
        : Option[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] = scala
      .Option(impl.excludedRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.ExcludedRule.wrap(item)
        }.toList
      )
    override val scopeDownStatement
        : Option[zio.aws.wafv2.model.Statement.ReadOnly] = scala
      .Option(impl.scopeDownStatement())
      .map(value => zio.aws.wafv2.model.Statement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ): zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly = new Wrapper(impl)
}
