package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListIpSetsResponse(
    nextMarker: Option[NextMarker] = None,
    ipSets: Option[Iterable[zio.aws.wafv2.model.IPSetSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse = {
    import ListIpSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ipSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipSets)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly =
    zio.aws.wafv2.model.ListIpSetsResponse.wrap(buildAwsValue())
}
object ListIpSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListIpSetsResponse =
      zio.aws.wafv2.model.ListIpSetsResponse(
        nextMarker.map(value => value),
        ipSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def ipSets: Option[List[zio.aws.wafv2.model.IPSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getIpSets
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.IPSetSummary.ReadOnly]] =
      AwsError.unwrapOptionField("ipSets", ipSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse
  ) extends zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val ipSets
        : Option[List[zio.aws.wafv2.model.IPSetSummary.ReadOnly]] = scala
      .Option(impl.ipSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.IPSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListIpSetsResponse
  ): zio.aws.wafv2.model.ListIpSetsResponse.ReadOnly = new Wrapper(impl)
}
