package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class GetWebAclResponse(
    webACL: Option[zio.aws.wafv2.model.WebACL] = None,
    lockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetWebAclResponse = {
    import GetWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetWebAclResponse.ReadOnly =
    zio.aws.wafv2.model.GetWebAclResponse.wrap(buildAwsValue())
}
object GetWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetWebAclResponse =
      zio.aws.wafv2.model.GetWebAclResponse(
        webACL.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def webACL: Option[zio.aws.wafv2.model.WebACL.ReadOnly]
    def lockToken: Option[LockToken]
    def getWebACL: ZIO[Any, AwsError, zio.aws.wafv2.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ) extends zio.aws.wafv2.model.GetWebAclResponse.ReadOnly {
    override val webACL: Option[zio.aws.wafv2.model.WebACL.ReadOnly] = scala
      .Option(impl.webACL())
      .map(value => zio.aws.wafv2.model.WebACL.wrap(value))
    override val lockToken: Option[LockToken] = scala
      .Option(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetWebAclResponse
  ): zio.aws.wafv2.model.GetWebAclResponse.ReadOnly = new Wrapper(impl)
}
