package zio.aws.wafv2.model
import scala.jdk.CollectionConverters._
sealed trait FailureReason {
  def unwrap: software.amazon.awssdk.services.wafv2.model.FailureReason
}
object FailureReason {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.FailureReason
  ): zio.aws.wafv2.model.FailureReason = value match {
    case software.amazon.awssdk.services.wafv2.model.FailureReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.FailureReason.TOKEN_MISSING =>
      val r = TOKEN_MISSING
      r
    case software.amazon.awssdk.services.wafv2.model.FailureReason.TOKEN_EXPIRED =>
      val r = TOKEN_EXPIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FailureReason =
      software.amazon.awssdk.services.wafv2.model.FailureReason.UNKNOWN_TO_SDK_VERSION
  }
  case object TOKEN_MISSING extends zio.aws.wafv2.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FailureReason =
      software.amazon.awssdk.services.wafv2.model.FailureReason.TOKEN_MISSING
  }
  case object TOKEN_EXPIRED extends zio.aws.wafv2.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FailureReason =
      software.amazon.awssdk.services.wafv2.model.FailureReason.TOKEN_EXPIRED
  }
}
