package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CaptchaAction(
    customRequestHandling: Option[zio.aws.wafv2.model.CustomRequestHandling] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CaptchaAction = {
    import CaptchaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CaptchaAction
      .builder()
      .optionallyWith(
        customRequestHandling.map(value => value.buildAwsValue())
      )(_.customRequestHandling)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CaptchaAction.ReadOnly =
    zio.aws.wafv2.model.CaptchaAction.wrap(buildAwsValue())
}
object CaptchaAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CaptchaAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CaptchaAction = zio.aws.wafv2.model
      .CaptchaAction(customRequestHandling.map(value => value.asEditable))
    def customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly]
    def getCustomRequestHandling: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.CustomRequestHandling.ReadOnly
    ] =
      AwsError.unwrapOptionField("customRequestHandling", customRequestHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaAction
  ) extends zio.aws.wafv2.model.CaptchaAction.ReadOnly {
    override val customRequestHandling
        : Option[zio.aws.wafv2.model.CustomRequestHandling.ReadOnly] = scala
      .Option(impl.customRequestHandling())
      .map(value => zio.aws.wafv2.model.CustomRequestHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaAction
  ): zio.aws.wafv2.model.CaptchaAction.ReadOnly = new Wrapper(impl)
}
