package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class XssMatchStatement(
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.XssMatchStatement = {
    import XssMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.XssMatchStatement
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.XssMatchStatement.ReadOnly =
    zio.aws.wafv2.model.XssMatchStatement.wrap(buildAwsValue())
}
object XssMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.XssMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.XssMatchStatement =
      zio.aws.wafv2.model.XssMatchStatement(
        fieldToMatch.asEditable,
        textTransformations.map { item =>
          item.asEditable
        }
      )
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.XssMatchStatement
  ) extends zio.aws.wafv2.model.XssMatchStatement.ReadOnly {
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.XssMatchStatement
  ): zio.aws.wafv2.model.XssMatchStatement.ReadOnly = new Wrapper(impl)
}
