package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.wafv2.model.primitives.{LockToken, Timestamp, VersionKeyString}
import scala.jdk.CollectionConverters._
final case class UpdateManagedRuleSetVersionExpiryDateResponse(
    expiringVersion: Option[VersionKeyString] = None,
    expiryTimestamp: Option[Timestamp] = None,
    nextLockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse = {
    import UpdateManagedRuleSetVersionExpiryDateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
      .builder()
      .optionallyWith(
        expiringVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.expiringVersion)
      .optionallyWith(
        expiryTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiryTimestamp)
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly =
    zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
      .wrap(buildAwsValue())
}
object UpdateManagedRuleSetVersionExpiryDateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse =
      zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse(
        expiringVersion.map(value => value),
        expiryTimestamp.map(value => value),
        nextLockToken.map(value => value)
      )
    def expiringVersion: Option[VersionKeyString]
    def expiryTimestamp: Option[Timestamp]
    def nextLockToken: Option[LockToken]
    def getExpiringVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("expiringVersion", expiringVersion)
    def getExpiryTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiryTimestamp", expiryTimestamp)
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ) extends zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly {
    override val expiringVersion: Option[VersionKeyString] = scala
      .Option(impl.expiringVersion())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val expiryTimestamp: Option[Timestamp] = scala
      .Option(impl.expiryTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val nextLockToken: Option[LockToken] = scala
      .Option(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ): zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly =
    new Wrapper(impl)
}
