package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuleAction(
    block: Option[zio.aws.wafv2.model.BlockAction] = None,
    allow: Option[zio.aws.wafv2.model.AllowAction] = None,
    count: Option[zio.aws.wafv2.model.CountAction] = None,
    captcha: Option[zio.aws.wafv2.model.CaptchaAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RuleAction = {
    import RuleAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleAction
      .builder()
      .optionallyWith(block.map(value => value.buildAwsValue()))(_.block)
      .optionallyWith(allow.map(value => value.buildAwsValue()))(_.allow)
      .optionallyWith(count.map(value => value.buildAwsValue()))(_.count)
      .optionallyWith(captcha.map(value => value.buildAwsValue()))(_.captcha)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleAction.ReadOnly =
    zio.aws.wafv2.model.RuleAction.wrap(buildAwsValue())
}
object RuleAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.RuleAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleAction =
      zio.aws.wafv2.model.RuleAction(
        block.map(value => value.asEditable),
        allow.map(value => value.asEditable),
        count.map(value => value.asEditable),
        captcha.map(value => value.asEditable)
      )
    def block: Option[zio.aws.wafv2.model.BlockAction.ReadOnly]
    def allow: Option[zio.aws.wafv2.model.AllowAction.ReadOnly]
    def count: Option[zio.aws.wafv2.model.CountAction.ReadOnly]
    def captcha: Option[zio.aws.wafv2.model.CaptchaAction.ReadOnly]
    def getBlock: ZIO[Any, AwsError, zio.aws.wafv2.model.BlockAction.ReadOnly] =
      AwsError.unwrapOptionField("block", block)
    def getAllow: ZIO[Any, AwsError, zio.aws.wafv2.model.AllowAction.ReadOnly] =
      AwsError.unwrapOptionField("allow", allow)
    def getCount: ZIO[Any, AwsError, zio.aws.wafv2.model.CountAction.ReadOnly] =
      AwsError.unwrapOptionField("count", count)
    def getCaptcha
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaAction.ReadOnly] =
      AwsError.unwrapOptionField("captcha", captcha)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleAction
  ) extends zio.aws.wafv2.model.RuleAction.ReadOnly {
    override val block: Option[zio.aws.wafv2.model.BlockAction.ReadOnly] = scala
      .Option(impl.block())
      .map(value => zio.aws.wafv2.model.BlockAction.wrap(value))
    override val allow: Option[zio.aws.wafv2.model.AllowAction.ReadOnly] = scala
      .Option(impl.allow())
      .map(value => zio.aws.wafv2.model.AllowAction.wrap(value))
    override val count: Option[zio.aws.wafv2.model.CountAction.ReadOnly] = scala
      .Option(impl.count())
      .map(value => zio.aws.wafv2.model.CountAction.wrap(value))
    override val captcha: Option[zio.aws.wafv2.model.CaptchaAction.ReadOnly] =
      scala
        .Option(impl.captcha())
        .map(value => zio.aws.wafv2.model.CaptchaAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleAction
  ): zio.aws.wafv2.model.RuleAction.ReadOnly = new Wrapper(impl)
}
