package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{
  VersionKeyString,
  LockToken,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class PutManagedRuleSetVersionsRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    lockToken: LockToken,
    recommendedVersion: Option[VersionKeyString] = None,
    versionsToPublish: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.VersionToPublish]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest = {
    import PutManagedRuleSetVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .optionallyWith(
        recommendedVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.recommendedVersion)
      .optionallyWith(
        versionsToPublish.map(value =>
          value
            .map({ case (key, value) =>
              (VersionKeyString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.versionsToPublish)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest.ReadOnly =
    zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest.wrap(buildAwsValue())
}
object PutManagedRuleSetVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest =
      zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest(
        name,
        scope,
        id,
        lockToken,
        recommendedVersion.map(value => value),
        versionsToPublish.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def lockToken: LockToken
    def recommendedVersion: Option[VersionKeyString]
    def versionsToPublish: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.VersionToPublish.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
    def getRecommendedVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("recommendedVersion", recommendedVersion)
    def getVersionsToPublish: ZIO[Any, AwsError, Map[
      VersionKeyString,
      zio.aws.wafv2.model.VersionToPublish.ReadOnly
    ]] = AwsError.unwrapOptionField("versionsToPublish", versionsToPublish)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest
  ) extends zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
    override val recommendedVersion: Option[VersionKeyString] = scala
      .Option(impl.recommendedVersion())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val versionsToPublish: Option[
      Map[VersionKeyString, zio.aws.wafv2.model.VersionToPublish.ReadOnly]
    ] = scala
      .Option(impl.versionsToPublish())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.VersionKeyString(
              key
            ) -> zio.aws.wafv2.model.VersionToPublish.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PutManagedRuleSetVersionsRequest
  ): zio.aws.wafv2.model.PutManagedRuleSetVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
