package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    resourceArn: ResourceArn,
    logDestinationConfigs: Iterable[ResourceArn],
    redactedFields: Option[Iterable[zio.aws.wafv2.model.FieldToMatch]] = None,
    managedByFirewallManager: Option[Boolean] = None,
    loggingFilter: Option[zio.aws.wafv2.model.LoggingFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.LoggingConfiguration
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .logDestinationConfigs(logDestinationConfigs.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        redactedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.redactedFields)
      .optionallyWith(
        managedByFirewallManager.map(value => value: java.lang.Boolean)
      )(_.managedByFirewallManager)
      .optionallyWith(loggingFilter.map(value => value.buildAwsValue()))(
        _.loggingFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.LoggingConfiguration.ReadOnly =
    zio.aws.wafv2.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.LoggingConfiguration =
      zio.aws.wafv2.model.LoggingConfiguration(
        resourceArn,
        logDestinationConfigs,
        redactedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedByFirewallManager.map(value => value),
        loggingFilter.map(value => value.asEditable)
      )
    def resourceArn: ResourceArn
    def logDestinationConfigs: List[ResourceArn]
    def redactedFields: Option[List[zio.aws.wafv2.model.FieldToMatch.ReadOnly]]
    def managedByFirewallManager: Option[Boolean]
    def loggingFilter: Option[zio.aws.wafv2.model.LoggingFilter.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getLogDestinationConfigs: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(logDestinationConfigs)
    def getRedactedFields
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.FieldToMatch.ReadOnly]] =
      AwsError.unwrapOptionField("redactedFields", redactedFields)
    def getManagedByFirewallManager: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("managedByFirewallManager", managedByFirewallManager)
    def getLoggingFilter
        : ZIO[Any, AwsError, zio.aws.wafv2.model.LoggingFilter.ReadOnly] =
      AwsError.unwrapOptionField("loggingFilter", loggingFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.LoggingConfiguration
  ) extends zio.aws.wafv2.model.LoggingConfiguration.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
    override val logDestinationConfigs: List[ResourceArn] = impl
      .logDestinationConfigs()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.ResourceArn(item)
      }
      .toList
    override val redactedFields
        : Option[List[zio.aws.wafv2.model.FieldToMatch.ReadOnly]] = scala
      .Option(impl.redactedFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.FieldToMatch.wrap(item)
        }.toList
      )
    override val managedByFirewallManager: Option[Boolean] =
      scala.Option(impl.managedByFirewallManager()).map(value => value: Boolean)
    override val loggingFilter
        : Option[zio.aws.wafv2.model.LoggingFilter.ReadOnly] = scala
      .Option(impl.loggingFilter())
      .map(value => zio.aws.wafv2.model.LoggingFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.LoggingConfiguration
  ): zio.aws.wafv2.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
