package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListLoggingConfigurationsResponse(
    loggingConfigurations: Option[
      Iterable[zio.aws.wafv2.model.LoggingConfiguration]
    ] = None,
    nextMarker: Option[NextMarker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse = {
    import ListLoggingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
      .builder()
      .optionallyWith(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loggingConfigurations)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly =
    zio.aws.wafv2.model.ListLoggingConfigurationsResponse.wrap(buildAwsValue())
}
object ListLoggingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListLoggingConfigurationsResponse =
      zio.aws.wafv2.model.ListLoggingConfigurationsResponse(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loggingConfigurations
        : Option[List[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]]
    def nextMarker: Option[NextMarker]
    def getLoggingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.LoggingConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("loggingConfigurations", loggingConfigurations)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ) extends zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly {
    override val loggingConfigurations
        : Option[List[zio.aws.wafv2.model.LoggingConfiguration.ReadOnly]] =
      scala
        .Option(impl.loggingConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.LoggingConfiguration.wrap(item)
          }.toList
        )
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListLoggingConfigurationsResponse
  ): zio.aws.wafv2.model.ListLoggingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
