package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{PaginationLimit, NextMarker}
import scala.jdk.CollectionConverters._
final case class ListIpSetsRequest(
    scope: zio.aws.wafv2.model.Scope,
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest = {
    import ListIpSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest
      .builder()
      .scope(scope.unwrap)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListIpSetsRequest.ReadOnly =
    zio.aws.wafv2.model.ListIpSetsRequest.wrap(buildAwsValue())
}
object ListIpSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListIpSetsRequest =
      zio.aws.wafv2.model.ListIpSetsRequest(
        scope,
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def scope: zio.aws.wafv2.model.Scope
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest
  ) extends zio.aws.wafv2.model.ListIpSetsRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafv2.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListIpSetsRequest
  ): zio.aws.wafv2.model.ListIpSetsRequest.ReadOnly = new Wrapper(impl)
}
