package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GeoMatchStatement(
    countryCodes: Option[Iterable[zio.aws.wafv2.model.CountryCode]] = None,
    forwardedIPConfig: Option[zio.aws.wafv2.model.ForwardedIPConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GeoMatchStatement = {
    import GeoMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GeoMatchStatement
      .builder()
      .optionallyWith(
        countryCodes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.countryCodesWithStrings)
      .optionallyWith(forwardedIPConfig.map(value => value.buildAwsValue()))(
        _.forwardedIPConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GeoMatchStatement.ReadOnly =
    zio.aws.wafv2.model.GeoMatchStatement.wrap(buildAwsValue())
}
object GeoMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GeoMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GeoMatchStatement =
      zio.aws.wafv2.model.GeoMatchStatement(
        countryCodes.map(value => value),
        forwardedIPConfig.map(value => value.asEditable)
      )
    def countryCodes: Option[List[zio.aws.wafv2.model.CountryCode]]
    def forwardedIPConfig
        : Option[zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly]
    def getCountryCodes
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.CountryCode]] =
      AwsError.unwrapOptionField("countryCodes", countryCodes)
    def getForwardedIPConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly] =
      AwsError.unwrapOptionField("forwardedIPConfig", forwardedIPConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GeoMatchStatement
  ) extends zio.aws.wafv2.model.GeoMatchStatement.ReadOnly {
    override val countryCodes: Option[List[zio.aws.wafv2.model.CountryCode]] =
      scala
        .Option(impl.countryCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.CountryCode.wrap(item)
          }.toList
        )
    override val forwardedIPConfig
        : Option[zio.aws.wafv2.model.ForwardedIPConfig.ReadOnly] = scala
      .Option(impl.forwardedIPConfig())
      .map(value => zio.aws.wafv2.model.ForwardedIPConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GeoMatchStatement
  ): zio.aws.wafv2.model.GeoMatchStatement.ReadOnly = new Wrapper(impl)
}
