package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{RulePriority, EntityName}
import scala.jdk.CollectionConverters._
final case class Rule(
    name: EntityName,
    priority: RulePriority,
    statement: zio.aws.wafv2.model.Statement,
    action: Option[zio.aws.wafv2.model.RuleAction] = None,
    overrideAction: Option[zio.aws.wafv2.model.OverrideAction] = None,
    ruleLabels: Option[Iterable[zio.aws.wafv2.model.Label]] = None,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Rule
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .priority(RulePriority.unwrap(priority): Integer)
      .statement(statement.buildAwsValue())
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(
        ruleLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleLabels)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Rule.ReadOnly =
    zio.aws.wafv2.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Rule = zio.aws.wafv2.model.Rule(
      name,
      priority,
      statement.asEditable,
      action.map(value => value.asEditable),
      overrideAction.map(value => value.asEditable),
      ruleLabels.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      visibilityConfig.asEditable,
      captchaConfig.map(value => value.asEditable)
    )
    def name: EntityName
    def priority: RulePriority
    def statement: zio.aws.wafv2.model.Statement.ReadOnly
    def action: Option[zio.aws.wafv2.model.RuleAction.ReadOnly]
    def overrideAction: Option[zio.aws.wafv2.model.OverrideAction.ReadOnly]
    def ruleLabels: Option[List[zio.aws.wafv2.model.Label.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def captchaConfig: Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getStatement
        : ZIO[Any, Nothing, zio.aws.wafv2.model.Statement.ReadOnly] =
      ZIO.succeed(statement)
    def getAction: ZIO[Any, AwsError, zio.aws.wafv2.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getOverrideAction
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OverrideAction.ReadOnly] =
      AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getRuleLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("ruleLabels", ruleLabels)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Rule
  ) extends zio.aws.wafv2.model.Rule.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val priority: RulePriority =
      zio.aws.wafv2.model.primitives.RulePriority(impl.priority())
    override val statement: zio.aws.wafv2.model.Statement.ReadOnly =
      zio.aws.wafv2.model.Statement.wrap(impl.statement())
    override val action: Option[zio.aws.wafv2.model.RuleAction.ReadOnly] = scala
      .Option(impl.action())
      .map(value => zio.aws.wafv2.model.RuleAction.wrap(value))
    override val overrideAction
        : Option[zio.aws.wafv2.model.OverrideAction.ReadOnly] = scala
      .Option(impl.overrideAction())
      .map(value => zio.aws.wafv2.model.OverrideAction.wrap(value))
    override val ruleLabels: Option[List[zio.aws.wafv2.model.Label.ReadOnly]] =
      scala
        .Option(impl.ruleLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Label.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val captchaConfig
        : Option[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] = scala
      .Option(impl.captchaConfig())
      .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Rule
  ): zio.aws.wafv2.model.Rule.ReadOnly = new Wrapper(impl)
}
