package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.LabelMatchKey
import scala.jdk.CollectionConverters._
final case class LabelMatchStatement(
    scope: zio.aws.wafv2.model.LabelMatchScope,
    key: LabelMatchKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.LabelMatchStatement = {
    import LabelMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.LabelMatchStatement
      .builder()
      .scope(scope.unwrap)
      .key(LabelMatchKey.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.LabelMatchStatement.ReadOnly =
    zio.aws.wafv2.model.LabelMatchStatement.wrap(buildAwsValue())
}
object LabelMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.LabelMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.LabelMatchStatement =
      zio.aws.wafv2.model.LabelMatchStatement(scope, key)
    def scope: zio.aws.wafv2.model.LabelMatchScope
    def key: LabelMatchKey
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.LabelMatchScope] =
      ZIO.succeed(scope)
    def getKey: ZIO[Any, Nothing, LabelMatchKey] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.LabelMatchStatement
  ) extends zio.aws.wafv2.model.LabelMatchStatement.ReadOnly {
    override val scope: zio.aws.wafv2.model.LabelMatchScope =
      zio.aws.wafv2.model.LabelMatchScope.wrap(impl.scope())
    override val key: LabelMatchKey =
      zio.aws.wafv2.model.primitives.LabelMatchKey(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.LabelMatchStatement
  ): zio.aws.wafv2.model.LabelMatchStatement.ReadOnly = new Wrapper(impl)
}
