package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FieldToMatch(
    singleHeader: Option[zio.aws.wafv2.model.SingleHeader] = None,
    singleQueryArgument: Option[zio.aws.wafv2.model.SingleQueryArgument] = None,
    allQueryArguments: Option[zio.aws.wafv2.model.AllQueryArguments] = None,
    uriPath: Option[zio.aws.wafv2.model.UriPath] = None,
    queryString: Option[zio.aws.wafv2.model.QueryString] = None,
    body: Option[zio.aws.wafv2.model.Body] = None,
    method: Option[zio.aws.wafv2.model.Method] = None,
    jsonBody: Option[zio.aws.wafv2.model.JsonBody] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.FieldToMatch = {
    import FieldToMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.FieldToMatch
      .builder()
      .optionallyWith(singleHeader.map(value => value.buildAwsValue()))(
        _.singleHeader
      )
      .optionallyWith(singleQueryArgument.map(value => value.buildAwsValue()))(
        _.singleQueryArgument
      )
      .optionallyWith(allQueryArguments.map(value => value.buildAwsValue()))(
        _.allQueryArguments
      )
      .optionallyWith(uriPath.map(value => value.buildAwsValue()))(_.uriPath)
      .optionallyWith(queryString.map(value => value.buildAwsValue()))(
        _.queryString
      )
      .optionallyWith(body.map(value => value.buildAwsValue()))(_.body)
      .optionallyWith(method.map(value => value.buildAwsValue()))(_.method)
      .optionallyWith(jsonBody.map(value => value.buildAwsValue()))(_.jsonBody)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
    zio.aws.wafv2.model.FieldToMatch.wrap(buildAwsValue())
}
object FieldToMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.FieldToMatch =
      zio.aws.wafv2.model.FieldToMatch(
        singleHeader.map(value => value.asEditable),
        singleQueryArgument.map(value => value.asEditable),
        allQueryArguments.map(value => value.asEditable),
        uriPath.map(value => value.asEditable),
        queryString.map(value => value.asEditable),
        body.map(value => value.asEditable),
        method.map(value => value.asEditable),
        jsonBody.map(value => value.asEditable)
      )
    def singleHeader: Option[zio.aws.wafv2.model.SingleHeader.ReadOnly]
    def singleQueryArgument
        : Option[zio.aws.wafv2.model.SingleQueryArgument.ReadOnly]
    def allQueryArguments
        : Option[zio.aws.wafv2.model.AllQueryArguments.ReadOnly]
    def uriPath: Option[zio.aws.wafv2.model.UriPath.ReadOnly]
    def queryString: Option[zio.aws.wafv2.model.QueryString.ReadOnly]
    def body: Option[zio.aws.wafv2.model.Body.ReadOnly]
    def method: Option[zio.aws.wafv2.model.Method.ReadOnly]
    def jsonBody: Option[zio.aws.wafv2.model.JsonBody.ReadOnly]
    def getSingleHeader
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SingleHeader.ReadOnly] =
      AwsError.unwrapOptionField("singleHeader", singleHeader)
    def getSingleQueryArgument
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SingleQueryArgument.ReadOnly] =
      AwsError.unwrapOptionField("singleQueryArgument", singleQueryArgument)
    def getAllQueryArguments
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AllQueryArguments.ReadOnly] =
      AwsError.unwrapOptionField("allQueryArguments", allQueryArguments)
    def getUriPath: ZIO[Any, AwsError, zio.aws.wafv2.model.UriPath.ReadOnly] =
      AwsError.unwrapOptionField("uriPath", uriPath)
    def getQueryString
        : ZIO[Any, AwsError, zio.aws.wafv2.model.QueryString.ReadOnly] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getBody: ZIO[Any, AwsError, zio.aws.wafv2.model.Body.ReadOnly] =
      AwsError.unwrapOptionField("body", body)
    def getMethod: ZIO[Any, AwsError, zio.aws.wafv2.model.Method.ReadOnly] =
      AwsError.unwrapOptionField("method", method)
    def getJsonBody: ZIO[Any, AwsError, zio.aws.wafv2.model.JsonBody.ReadOnly] =
      AwsError.unwrapOptionField("jsonBody", jsonBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ) extends zio.aws.wafv2.model.FieldToMatch.ReadOnly {
    override val singleHeader
        : Option[zio.aws.wafv2.model.SingleHeader.ReadOnly] = scala
      .Option(impl.singleHeader())
      .map(value => zio.aws.wafv2.model.SingleHeader.wrap(value))
    override val singleQueryArgument
        : Option[zio.aws.wafv2.model.SingleQueryArgument.ReadOnly] = scala
      .Option(impl.singleQueryArgument())
      .map(value => zio.aws.wafv2.model.SingleQueryArgument.wrap(value))
    override val allQueryArguments
        : Option[zio.aws.wafv2.model.AllQueryArguments.ReadOnly] = scala
      .Option(impl.allQueryArguments())
      .map(value => zio.aws.wafv2.model.AllQueryArguments.wrap(value))
    override val uriPath: Option[zio.aws.wafv2.model.UriPath.ReadOnly] = scala
      .Option(impl.uriPath())
      .map(value => zio.aws.wafv2.model.UriPath.wrap(value))
    override val queryString: Option[zio.aws.wafv2.model.QueryString.ReadOnly] =
      scala
        .Option(impl.queryString())
        .map(value => zio.aws.wafv2.model.QueryString.wrap(value))
    override val body: Option[zio.aws.wafv2.model.Body.ReadOnly] = scala
      .Option(impl.body())
      .map(value => zio.aws.wafv2.model.Body.wrap(value))
    override val method: Option[zio.aws.wafv2.model.Method.ReadOnly] = scala
      .Option(impl.method())
      .map(value => zio.aws.wafv2.model.Method.wrap(value))
    override val jsonBody: Option[zio.aws.wafv2.model.JsonBody.ReadOnly] = scala
      .Option(impl.jsonBody())
      .map(value => zio.aws.wafv2.model.JsonBody.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ): zio.aws.wafv2.model.FieldToMatch.ReadOnly = new Wrapper(impl)
}
